﻿<?xml version="1.0" ?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
				xmlns:feed="http://www.w3.org/2005/Atom"
				xmlns:fr="http://www.feedreader.com/ns/3.0"
				xmlns:frc="http://www.feedreader.com/ns/3.0/frc"
				version="1.0">
<xsl:output method="html" />

<xsl:template match="/">

<html>
  <head>
    <title><xsl:value-of select="/feed:feed/feed:title"/></title>
    <link rel="stylesheet" href="atom.css"/>
    <style>

body {
 font-family: verdana, tahoma;
 font-size: 0.7em;
 line-height: 1.3em;
 padding: 0;
 margin: 0;
}


a, a:link, a:active, a:visited {
 text-decoration: none;
 color: #0088ff;
}

div.entry {
 padding: 0 20px 20px 25px;
 border-bottom: 1px solid #ddd;
}

div.content img {
}

div.active {
 background-color: #f1f5fa;;
}

.read .title a {
 color: #aaa;
}


.read .content {
 color: #555;
}

div.entry .read .title a {
 color: gray;
}

.header {
 padding-top: 20px;
 margin: 0 0 0.2em 0;
}

.title {
 font-size: 1.6em;
 font-family: arial, verdana, tahoma;
 font-weight: bold;
 letter-spacing: -1px;
 line-height: 1.1em;
}

div.details {
 color: gray;
 margin-bottom: 0.5em;
}
div.clear {
 clear:both;
 height: 1px;
 width: 1px;
 font-size: 1px;
 line-height: 1px;
}
span.modified, span.author, span.category {
}

.status a {
 display:block;
 line-height: 0;
 font-size: 0;
 width: 8px; 
 height: 8px;
 margin-top: -1.5em;
 background-repeat: no-repeat;
}

.read .status a {
}






</style>
    
<base>    
<xsl:attribute name="href"><xsl:value-of select="/feed:feed/feed:entry/feed:source/feed:link[@rel='alternate'][1]/@href"/>/</xsl:attribute>
</base>
 
  </head>	
  <body>
  <xsl:apply-templates select="feed:feed"/>
  </body>
</html>
</xsl:template>

<xsl:template match="feed:feed">
  <xsl:apply-templates select="feed:entry"/>
</xsl:template>

<xsl:template match="feed:entry">

	<div class="entry">
		<xsl:attribute name="id">article<xsl:value-of select="fr:item_id"/></xsl:attribute>
		<xsl:if test="fr:rtlEnabled = 1">
			<xsl:attribute name="style">direction:RTL;</xsl:attribute>
		</xsl:if>
		<xsl:if test="fr:status = 1">
			<xsl:attribute name="class">entry read</xsl:attribute>
		</xsl:if>
				
		<div class="header">

		<span class="title">
			<a>
			<xsl:attribute name="href"><xsl:value-of select="feed:link/@href"/></xsl:attribute>
			<xsl:value-of select="feed:title"/>
			</a>
		</span>

		  <span class="status">
		  <xsl:attribute name="style">float:right;</xsl:attribute>
	      <xsl:if test="fr:rtlEnabled = 1">
	    	<xsl:attribute name="style">float:left;</xsl:attribute>
		  </xsl:if>
	      <xsl:if test="fr:rtlEnabled != 1">
	    	<xsl:attribute name="style">float:right;</xsl:attribute>
		  </xsl:if>
		  
		  </span>
		</div>
	
                <div class="details">
		 	<span class="updated"><xsl:value-of select="fr:updated"/>, </span>		
			<xsl:if test="feed:author"> 
	  			<span class="author">
				<xsl:apply-templates select="feed:author"/>
				</span>
			</xsl:if>
                        
			<xsl:if test="feed:category">
			  	<span class="category"> 
  				<xsl:apply-templates select="feed:category"/>
				</span>
                	</xsl:if>
			<xsl:if test="feed:source">
			  	<span class="source"> 
				<a>
				<xsl:attribute name="href">
				<!-- <xsl:for-each select = "feed:source/feed:link[@rel='alternate']"> --> 
    				<xsl:value-of select = "feed:source/feed:link[@rel='alternate'][1]/@href"/> 
    				<!-- </xsl:for-each> -->
				</xsl:attribute>
				<xsl:value-of select="feed:source/feed:title"/>
				</a>
				</span>
                                
                	</xsl:if>
		</div>

	<xsl:if test="feed:content">
		<div class="content">
			<xsl:value-of disable-output-escaping="yes" select="feed:content"/>
		</div>
	</xsl:if>
	<div class="clear" />
	</div>

</xsl:template>

<xsl:template match="feed:category">
  <a>
  <xsl:attribute name="href">#</xsl:attribute>
  <xsl:value-of select="./@term"/>
  </a>, 
</xsl:template>

<xsl:template match="feed:author">
  <xsl:value-of select="feed:name"/>, 
</xsl:template>

</xsl:stylesheet>
